# Copyright (C) 2013-2023 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 11-May-2023 17:11.

"""destTarget userdefined datapoint type, originally defined in resource file
set apollodev 90:00:01:06:00:00:00:00-4.  """


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined


class destTarget(izot.resources.base.Structure):
    """destTarget userdefined datapoint type.  ."""

    def __init__(self):
        super().__init__(
            key=8,
            scope=4
        )

        self.__domain_index = izot.resources.base.Scaled(
            size=1,
            signed=False,
            minimum=0,
            maximum=255
        )
        self._register(('domain_index', self.__domain_index))

        self.__subnet = izot.resources.base.Scaled(
            size=1,
            signed=False,
            minimum=0,
            maximum=255
        )
        self._register(('subnet', self.__subnet))

        self.__node = izot.resources.base.Scaled(
            size=1,
            signed=False,
            minimum=0,
            maximum=255
        )
        self._register(('node', self.__node))

        self.__label = izot.resources.base.Array(
            [
                izot.resources.base.Scaled(
                    size=1,
                    signed=False,
                    minimum=0,
                    maximum=255
                ) for i in range(16)
            ]
        )
        self._register(('label', self.__label))

        self.__handle = izot.resources.base.Scaled(
            size=4,
            signed=False,
            minimum=0,
            maximum=4294967295
        )
        self._register(('handle', self.__handle))
        self._original_name = 'UNVTdestTarget'
        self._definition = userdefined.add(self)


    def __set_domain_index(self, v):
        self.__domain_index._value = v

    domain_index = property(
        lambda self: self.__domain_index._value,
        __set_domain_index,
        None,
        """."""
    )

    def __set_subnet(self, v):
        self.__subnet._value = v

    subnet = property(
        lambda self: self.__subnet._value,
        __set_subnet,
        None,
        """."""
    )

    def __set_node(self, v):
        self.__node._value = v

    node = property(
        lambda self: self.__node._value,
        __set_node,
        None,
        """."""
    )

    def __set_label(self, v):
        self.__label._value = v

    label = property(
        lambda self: self.__label._value,
        __set_label,
        None,
        """."""
    )

    def __set_handle(self, v):
        self.__handle._value = v

    handle = property(
        lambda self: self.__handle._value,
        __set_handle,
        None,
        """."""
    )

    def __len__(self):
        """Return the length of the type, in bytes."""
        return 23


if __name__ == '__main__':
    # unit test code.
    item = destTarget()
    pass
